from autogen_ext.models.openai import OpenAIChatCompletionClient
from autogen_ext.teams.magentic_one import MagenticOne
from autogen_agentchat.ui import Console
import asyncio
from dotenv import load_dotenv
import os

load_dotenv()

# Set environment variable to force headed mode for Playwright
os.environ["PLAYWRIGHT_HEADLESS"] = "false"

os.environ["PWDEBUG"] = "1"  # This enables Playwright inspector too

async def example_usage():
    client = OpenAIChatCompletionClient(model="gpt-4o")
    
    
    m1 = MagenticOne(
        client=client
    )
    
    task = "Please find all Instructors for the course Large Language Models and Agents (FSS2025) at the university of Mannheim. Please return the room and phone number for every Instructor to me."
    result = await Console(m1.run_stream(task=task))
    print(result)


if __name__ == "__main__":
    asyncio.run(example_usage())